import sys
from PyQt5 import uic
from PyQt5.QtWidgets import QApplication, QMainWindow


class MyWidget(QMainWindow):
    def __init__(self):
        super().__init__()
        uic.loadUi('mini.ui', self)
        self.initUI()

    def initUI(self):
        self.date = {}
        self.pushButton.clicked.connect(self.run)

    def run(self):
        strdate = self.calendarWidget.selectedDate().getDate()
        self.date[f'{strdate[0]}-{strdate[1]}-{strdate[2]}-{self.timeEdit.time().toString()}'] = self.lineEdit.text()
        self.textBrowser.clear()
        for key in sorted(self.date.keys()):
            self.textBrowser.append(f'{key} - {self.date[key]}')


if __name__ == '__main__':
    app = QApplication(sys.argv)
    ex = MyWidget()
    ex.show()
    sys.exit(app.exec_())